/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.npc.LOTREntityBlackUruk;
import lotr.common.entity.npc.LOTRUnitTradeEntries;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.world.spawning.LOTRInvasions;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LOTREntityBlackUrukCaptain
extends LOTREntityBlackUruk
implements LOTRUnitTradeable {
    public LOTREntityBlackUrukCaptain(World world) {
        super(world);
        this.addTargetTasks(false);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.orcSkullStaff));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsBlackUruk));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsBlackUruk));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyBlackUruk));
        this.func_70062_b(4, null);
        return data;
    }

    @Override
    public float getAlignmentBonus() {
        return 5.0f;
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            player.func_70690_d(new PotionEffect(LOTRPotions.curse.field_76415_H, 24000, 0));
        }
    }

    @Override
    public LOTRUnitTradeEntries getUnits() {
        return LOTRUnitTradeEntries.BLACK_URUK_CAPTAIN;
    }

    @Override
    public LOTRInvasions getConquestHorn() {
        return LOTRInvasions.MORDOR_BLACK_URUK;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 400.0f && this.isFriendly(entityplayer);
    }

    @Override
    public void onUnitTrade(EntityPlayer entityplayer) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeBlackUrukCaptain);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "mordor/blackUrukCaptain/friendly";
            }
            return "mordor/blackUrukCaptain/neutral";
        }
        return "mordor/orc/hostile";
    }
}

